//****************************************************************
//   Generalizes Bass Model
//   Using estimated analogous products parameters 
//     AUTHOR  Shigeru Kido      
//     Scilab-5.3.3 Windows 7 version 
//     Updated               (Feb. 26. 2012.)
//     THE PROGRAM NAME      GBassModel-2.sce
//From displays a choice of four product categories of products based on their market //performance:
//Low p; Low q, (slow growing products)
//Low p; High q, (products with slow takeoff but high "contagion" after takeoff)
//High p; Low q, (products with high takeoff, but low contagion thereafter)  and  
//High p; High q (fast growing products). 
//****************************************************************
//Initialize
//clc();       //clear  commad window
clear ;   //clear  work space
//clf();      // clear current graph,reset default value
Fid=['GBASSoutput1.txt'];
 delmenu('G_BassMenu');delmenu('G_BassMenu');delmenu('G_BassMenu');
//
// test data sets(actuals)w/ t=0
ActSales=[0.0 60.7	82.1	118.4	181.3	188.7	312	413.1	424	408.2	575.2	461.7	478.5	340.2	190.5	224	104.1	224.8	69.5	25.7	17.4];
CumSales=[0.0 60.7	142.8	261.2	442.5	631.2	943.2	1356.3	1780.3	2188.5	2763.7	3225.4	3703.9	4044.1	4234.6	4458.6	4562.7	4787.5	4857	4882.7	4900.1];
//Price Cum.Index w/ t=0
Pr=[1.0	1.1	1.1	1.3	1.4	1.5	1.6	1.7	1.9	2.3	2.3	2.8	2.8	3.4	4.0	4.0	4.1	4.5	4.6	4.9	5.4];
//Advertising Cum.Index w/ t=0
Adv=[5.0	5.8	6.5	7.4	8.8	10.1	11.6	13.9	16.1	18.1	21.5	25.6	29.4	32.8	38.2	44.7	52.1	61.6	68.4	78.5	89.0];
//
//:------------------------------------------------------   
function Disp_Title()
// Display title
//:------------------------------------------------------   
 w=getdate()
mprintf('Date: %d. %d/%d. Time:%d: %d:%d. \n',w(1),w(2),w(6),w(7), w(8),w(9));
mprintf('_/_/_/_/_/_/_/_/_/_/_/_/_//_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/\n');
mprintf('_/_/_/_/_/       The Generalized Bass Model          _/_/_/_/_/\n');  
mprintf('_/               Using Estimated  Parameters                 _/\n');
mprintf('_/            Scilab-5.3.3 Windows 7 version                 _/\n');
mprintf('_/            Author  :  S. Kido                             _/\n');
mprintf('_/            Update  :  Feb. 26, 2012.                      _/\n');
mprintf('_/            Program Name : GBassModel-2.sce                _/\n');
mprintf('_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_//_/\n');
mprintf('\n \n');  
// 
endfunction 
//:--------------------------------------------------------
function [p,q,m,n,b1,b2]=GUI_input_param()
//   GUI input and edit parameters: p, q, m, n  
//:--------------------------------------------------------
 ttl='The Generalized Bass Model : ';
 txt = [' External/ innovation Coefficient : p ';...
 'Internal/ imitation  Coefficient : q';...
 'Market potential Pop.(unit:1000) : m';...
 'Estimating Time (period:years)   : n';...
 'Price Effect Coefficent          : b1';...
 'Advertising Effect Coefficent    : b2'];
 def=['0.0079 ';'0.3355 ';'4977.4 ';...
     '20';'-1.2484 ';'1.8921 '];
BassParam = x_mdialog(ttl,txt,def)
p1 = evstr(BassParam(1))
q1 = evstr(BassParam(2))
m1 = evstr(BassParam(3))
n1 = evstr(BassParam(4))
b1 = evstr(BassParam(5))
b2 = evstr(BassParam(6))
//
p=p1;q=q1;m=m1;n=n1;
////////////////////////////////////////////////////////////////////////////
[ ActSales, CumSales, Pr, Adv, X, S,SqEr]=CompGBass(p,q,m,n,b1,b2);
          Disp_Model_Param(p,q,m,n,b1,b2) ;
          Output2File(p,q,m,n,b1,b2,ActSales,CumSales, Pr, Adv, X, S,SqEr);
/////////////////////////////////////////////////////////////////////////////          
endfunction  
//:--------------------------------------------------------- 
//:---------------------------------------------------------
function [a1,a2,a3,a4]=CompBass(p,q,m,n)
//   Compute Basic Bass Model
//    cumAtm1 is cumulative adoptions at t-1,
//  a(t) = p * m + (q - p) * cumAtm1 - (q / m) * (cumAtm1 ^ 2)
//
//:--------------------------------------------------------
     cumAtm1=0;
     a1=[];
     a2=[];
     a3=[];
     a4=[];
     for  t=1:n;
       a1(t) = p * m + (q - p) * cumAtm1 - (q / m) * (cumAtm1 ^ 2);
            cumAtm1=cumAtm1+a1(t);
            a2(t)=cumAtm1;
            a3(t)=100*(cumAtm1)/m;
            a4(t)=100*a1(t)/m; //  a4(t)=100*a1(t)/cumAtm1   
     end ;  
endfunction
//:--------------------------------------------------------
function [ ActSales, CumSales, Pr, Adv, X, S,SqEr]=CompGBass(p,q,m,n,b1,b2)    
//Generalized BASS Model:	
// The model generalizes the classical BASS model to include decision variables
// price(Pr) and advertising(Adv).	
// The BASS model predicts the sales of a recently introduced product.
// The basic model has three parameters:	
//  p : Innovator effect.  Measures the willingness to try a new product.	
//  q : Immator effect. The effect of existing users causing others to buy the product.	
//  m : Target population size. The number that will/could eventually buy the product.	
// The extended model adds two additional parameter:	
//  b1 : the effect of price on sales,	
//  b2 : the effect of advertising on sales.	
// The optimization model below estimates the above five parameters based on given data.	
//	S(t) = m*(1-exp[-(X(t)-X(0))*(p+q)])/(1+(q/p)*exp[-(X(t)-X(0))*(p+q)])
//	X(t) = t + b1*Ln(Pr(t)/Pr(0)) + b2*Ln(Adv(t)/Adv(0))
//    When there are no exogenous variables (i.e. X(t) = t),
//    the model reduces to the classical BASS model as a special case. 
//
//Compute Generalized Bass Model   
//	S(t) = m*(1-exp[-(X(t)-X(0))*(p+q)])/(1+(q/p)*exp[-(X(t)-X(0))*(p+q)])
//	X(t) = t + b1*Ln(Pr(t)/Pr(0)) + b2*Ln(Adv(t)/Adv(0))
//
for t=2:n+1  
    tt=t-1;
    X(t) = tt + b1*log(Pr(t)/Pr(1)) + b2*log(Adv(t)/Adv(1));
     S(t) = m*(1-exp(-(X(t)-X(1))*(p+q)))/(1+(q/p)*exp(-(X(t)-X(1))*(p+q)));
end
//
t=1;tt=t-1;
mprintf('__________________________________________________________________________\n');
mprintf('Period       Cumulative      Price   Advertising  Mapping Forecasts Squared\n');
mprintf(' T    Sales     Sales         Pr(t)   Adv(t)       X(t)      S(t)    Error \n');
mprintf('__________________________________________________________________________\n');
mprintf('%3d  %7.1f    %7.1f     %7.1f  %7.1f   %7.1f  %7.1f  \n',...
             tt, ActSales(t), CumSales(t), Pr(t), Adv(t), X(t), S(t) );    
             //
SSE=0;
for t=2:n+1
    tt=t-1;
    SqEr(tt)=(CumSales(t)- S(t))^2;
    SSE=SSE+SqEr(tt);
    mprintf('%3d  %7.1f    %7.1f     %7.1f  %7.1f   %7.1f  %7.1f  %7.1f\n',...
             tt, ActSales(t), CumSales(t), Pr(t), Adv(t), X(t), S(t),SqEr(tt));    
end
mprintf('                                     Sum of Squared Error = %12.1f \n',SSE);
mprintf('__________________________________________________________________________\n\n');
endfunction
//:--------------------------------------------------------
function Disp_Model_Param(p,q,m,n,b1,b2)  
//  Display parameters of current model
//:--------------------------------------------------------
     mprintf(' ______ Parameters of The Case Model_______\n\n' );
     mprintf('        innovation effects  p :  %7.4f \n', p);
     mprintf('        imitation effects   q :  %7.4f \n', q);
     mprintf('        market potential    m :  %7.1f \n', m);
     mprintf('        time (period)       n :  %7d   \n', n);
     mprintf('        price effect       b1 :  %7.4f \n', b1);
     mprintf('        advertising effect b2 :  %7.4f \n', b2);
     mprintf(' __________________________________________\n\n\n');
endfunction
//:--------------------------------------------------------
//:--------------------------------------------------------  
function Disp_Results(a1,a2,a3,a4)
// Display Summary of Results
//:--------------------------------------------------------
mprintf('=========   Bass Model: Summary of Results     ========= \n');
mprintf('-------------------------------------------------------- \n');                             
mprintf(' TIME   Sales      Cum.Sales     Rate(%%)   Cum.Rate(%%)   \n');
  for I=1:n;
mprintf('%3d  %10.3f  %10.3f    %7.1f    %7.1f\n',...
          I, a1(I),a2(I),a4(I),a3(I)); 
  end
endfunction
//:--------------------------------------------------------
//:--------------------------------------------------------
function  Plot_Graphs(ActSales, CumSales, Pr, Adv, X, S,SqEr,n )
// Plot graphs G_Bass
//:-------------------------------------------------------- 
//
ActSales=ActSales'; CumSales=CumSales';Pr=Pr';Adv=Adv'; X=X';S=S';SqEr=SqEr';
    //
dt =1;
Tm = 1 : dt : n+1;
Tm = Tm';
//
 scf(0); //
subplot(2,1,1);
plot2d(Tm, CumSales )  
xtitle ('Generalized Bass Model:  Cum. Sales ','Time Period (year)');
xgrid();
subplot(2,1,2);
plot2d(Tm,ActSales )
xtitle ('Generalized Bass Model:     Sales  ','Time Period (year)');
xgrid();
//
//open new window for comparision
scf(1);clf();
plot2d(Tm,[CumSales ],style=[color('black')]);
plot2d(Tm,[S ],style=[color('red')]);
legend('Actual',' Forcasts');
xtitle ('Generalized Bass Model: Actual Cum.Sales VS. Forcasts','Time Period (year)');
xgrid();
endfunction
//:-----------------------------------------------------------------------
function ExitSys()
    //  abort this program
     mprintf('(Bye ...!)\n');
delmenu('G_BassMenu');
     abort;
endfunction
//:----------------------------------------------------------------------
function Output2File(p,q,m,n,b1,b2,ActSales,CumSales, Pr, Adv, X, S,SqEr)
//  Output to Text-file
//:-------------------------------------------------------  
//
Title='Generalized Bass Model:';
Prompt=[' Enter Output File Name: '];
Def=['GBASSoutput1.txt'];
Answer=x_mdialog(Title,Prompt,Def);
//
Fid=mopen(Answer,'a')
//
 w=getdate()
mfprintf(Fid,'Date: %d. %d/%d. Time:%d: %d:%d. \n',w(1),w(2),w(6),w(7), w(8),w(9));
mfprintf(Fid,'___________________________________________________ \n\n');

mfprintf(Fid,'           The Generalized Bass Model         \n');
mfprintf(Fid,'___________________________________________________ \n');
  mfprintf(Fid,'\n\n');
  mfprintf(Fid,'Output File-Name :%s \n\n',Answer);
  //  Display parameters of current model
//:--------------------------------------------------------
     mfprintf(Fid,' ______ Parameters of The Case Model_______\n\n' );
     mfprintf(Fid,'        innovation effects  p :  %7.4f \n', p);
     mfprintf(Fid,'        imitation effects   q :  %7.4f \n', q);
     mfprintf(Fid,'        market potential    m :  %7.1f \n', m);
     mfprintf(Fid,'        time (period)       n :  %7d   \n', n);
     mfprintf(Fid,'        price effect       b1 :  %7.4f \n', b1);
     mfprintf(Fid,'        advertising effect b2 :  %7.4f \n', b2);
     mfprintf(Fid,' __________________________________________\n\n\n');
//
t=1;tt=t-1;
mfprintf(Fid,'__________________________________________________________________________\n\n'); 
mfprintf(Fid,'Period       Cumulative      Price   Advertising  Mapping Forecasts Squared\n');
mfprintf(Fid,' T    Sales     Sales         Pr(t)   Adv(t)       X(t)      S(t)    Error \n');
mfprintf(Fid,'__________________________________________________________________________\n');
mfprintf(Fid,'%3d  %7.1f    %7.1f     %7.1f  %7.1f   %7.1f  %7.1f  \n',...
             tt, ActSales(t), CumSales(t), Pr(t), Adv(t), X(t), S(t) );    
             //
 SSE=0;
for t=2:n+1
    tt=t-1;
    SqEr(tt)=(CumSales(t)- S(t))^2;
    SSE=SSE+SqEr(tt);
    mfprintf(Fid,'%3d  %7.1f    %7.1f     %7.1f  %7.1f   %7.1f  %7.1f  %7.1f\n',...
             tt, ActSales(t), CumSales(t), Pr(t), Adv(t), X(t), S(t),SqEr(tt));    
end
mfprintf(Fid,'                                     Sum of Squared Error = %12.1f \n',SSE);
mfprintf(Fid,'__________________________________________________________________________\n\n'); 
mclose(Fid);  
endfunction
//:--------------------------------------------------------
//:-------------------------------------------------------------------------
//
//:---------------------------------------------------
//: Main Program
//---------------------------------------------------- 
// call functions:
  Disp_Title();
  [p,q,m,n,b1,b2]=GUI_input_param(); // include below 3 functions
[ ActSales, CumSales, Pr, Adv, X, S,SqEr]=CompGBass(p,q,m,n,b1,b2);
  //        Disp_Model_Param(p,q,m,n,b1,b2) ;
  //       Output2File(p,q,m,n,b1,b2,ActSales,CumSales, Pr, Adv, X, S,SqEr);
 Plot_Graphs(ActSales, CumSales, Pr, Adv, X, S,SqEr,n )
// [a1,a2,a3,a4]=CompBass(p,q,m,n);
//  Disp_Results(a1,a2,a3,a4);
//  Plot_Graphs(a1,a2,a3,a4); 
// 
 addmenu('G_BassMenu',...
      ['Edit Parameters';...
      ' Plot_Graphs';...
       'Exit'] );
      G_BassMenu  =['[p,q,m,n,b1,b2]=GUI_input_param()',...
                 ' Plot_Graphs(ActSales, CumSales, Pr, Adv, X, S,SqEr,n )',...
                   'ExitSys()'];
//-------------------------------------------

